---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices, caractères gras, police grasse, 
              graisse du texte, passer en gras, bascule
---

# Comment mettre du texte en gras ?

## Avec les commandes de base

La commande `\textbf` compose son argument en caractères gras (`bf` pour *bold font*). 
Elle est limitée à la composition d'un paragraphe.

La bascule `{\bfseries ...}` modifie le texte qui suit, le compose en gras. 
La bascule et le texte concerné sont alors mis entre accolades. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Un premier \textbf{exemple}.

\vskip5pt
{\bfseries Un second exemple avec la bascule.

Avec deux paragraphes composés en gras.}

Un troisième exemple avec la police de base.
\end{document}
```

Des commandes et des bascules sont disponibles pour mettre en italique, 
en petites capitales, avec une police sans empattement, à chasse fixe, etc. 
Voir la page "[](changer_la_forme_d_une_fonte)".


## Une ancienne syntaxe : `\bf`

Des documentations anciennes peuvent indiquer la commande `\bf` pour passer en caractères gras, 
avec cette syntaxe :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Un {\bf bel} exemple.
\end{document}
```

Cette syntaxe est obsolète depuis 1994. Voir ce sujet la question 
"[](pourquoi_ne_pas_utiliser_bf_et_it)".


## Inventer du gras avec `\pmb`

Il peut arriver que certains symboles ne soient pas disponibles en gras. 
Dans ce cas, vous pouvez essayer d’"inventer" leur forme grasse 
avec la commande `\pmb` de l'extension <ctanpkg:amsmath>.

Cette commande écrit son argument trois fois l'une sur l'autre, avec un léger décalage, 
pour donner l'impression visuelle que les traits sont plus épais. 
C'est le *gras du pauvre* (d'où le nom de la commande : "**p**oor **m**an's **b**old"). 
Le rendu n'est généralement pas très beau (voir l'exemple de texte ci-dessous), 
et il reste toujours préférable d'utiliser un vrai caractère gras.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}       % Quelques fonctions graphiques
  \usepackage{bbding}         % Symbole Peace
  \usepackage{amsmath}

\begin{document}
\scalebox{1.5}{\Peace{} \textbf{\Peace} \pmb{\Peace}}

\scalebox{1.5}{Un \pmb{moins bel} exemple.}

\scalebox{1.5}{Un \textbf{moins bel} exemple.}
\end{document}
```