/*
 * Copyright (c) 2007 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/** @mainpage Heimdal PKIX/X.509 library
 *
 * @section intro Introduction
 *
 * Heimdal libhx509 library is a implementation of the PKIX/X.509 and
 * related protocols.
 *
 * PKIX/X.509 is ...
 *
 *
 * Sections in this manual are:
 * - @ref page_name
 * - @ref page_cert
 * - @ref page_keyset
 * - @ref page_error
 * - @ref page_lock
 * - @ref page_cms
 * - @ref page_ca
 * - @ref page_revoke
 * - @ref page_print
 * - @ref page_env
 *
 * The project web page:
 * http://www.h5l.org/
 *
 */

/** @defgroup hx509 hx509 library */

/** @defgroup hx509_error hx509 error functions
 * See the @ref page_error for description and examples. */
/** @defgroup hx509_cert hx509 certificate functions
 * See the @ref page_cert for description and examples. */
/** @defgroup hx509_keyset hx509 certificate store functions
 * See the @ref page_keyset for description and examples. */
/** @defgroup hx509_cms hx509 CMS/pkcs7 functions
 * See the @ref page_cms for description and examples. */
/** @defgroup hx509_crypto hx509 crypto functions */
/** @defgroup hx509_misc hx509 misc functions */
/** @defgroup hx509_name hx509 name functions
 * See the @ref page_name for description and examples. */
/** @defgroup hx509_revoke hx509 revokation checking functions
 * See the @ref page_revoke for description and examples. */
/** @defgroup hx509_verify hx509 verification functions */
/** @defgroup hx509_lock hx509 lock functions
 * See the @ref page_lock for description and examples. */
/** @defgroup hx509_query hx509 query functions */
/** @defgroup hx509_ca hx509 CA functions
 * See the @ref page_ca for description and examples. */
/** @defgroup hx509_peer hx509 certificate selecting functions */
/** @defgroup hx509_print hx509 printing functions */
/** @defgroup hx509_env hx509 environment functions */
