% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE3.R
\name{AE3}
\alias{AE3}
\title{AE model using nuclear family trios}
\usage{
AE3(model, random, data, seed = 1234, n.sim = 50000, verbose = TRUE)
}
\arguments{
\item{model}{a linear mixed model formula, see example below.}

\item{random}{random effect, see exampe below.}

\item{data}{data to be analyzed.}

\item{seed}{random number seed.}

\item{n.sim}{number of simulations.}

\item{verbose}{a flag for printing out results.}
}
\value{
The returned value is a list containing:
\itemize{
\item lme.result the linear mixed model result.
\item h2 the heritability estimate.
\item CL confidence intervals.
}
}
\description{
AE model using nuclear family trios
}
\details{
This function is adapted from example 7.1 of Rabe-Hesketh et al. (2008). It
also procides heritability estimate and confidence intervals.
}
\note{
Adapted from f.mbf.R from the paper.
}
\examples{
\dontrun{
require(gap.datasets)
AE3(bwt ~ male + first + midage + highage + birthyr,
    list(familyid = pdIdent(~var1 + var2 + var3 -1)), mfblong)
}

}
\references{
\insertRef{rh08}{gap}
}
\author{
Jing Hua Zhao
}
\keyword{htest}
\keyword{models}
