
''' Generated by OTF2 Template Engine '''

import ctypes
import traceback
import sys

from .Config import conf, StrParam, str_decode
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeValue import AttributeValue
from .Definitions import *
from .Callbacks import callback_wrapper


class GlobalDefReaderCallbacks(ctypes.Structure):
    pass

def GlobalDefReaderCallbacks_New():
    c_New = conf.lib.OTF2_GlobalDefReaderCallbacks_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(GlobalDefReaderCallbacks)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def GlobalDefReaderCallbacks_Delete(globalDefReaderCallbacks):
    c_Delete = conf.lib.OTF2_GlobalDefReaderCallbacks_Delete
    c_Delete.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks) ]
    c_Delete.restype = None
    return c_Delete(globalDefReaderCallbacks)

def GlobalDefReaderCallbacks_Clear(globalDefReaderCallbacks):
    c_Clear = conf.lib.OTF2_GlobalDefReaderCallbacks_Clear
    c_Clear.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks) ]
    c_Clear.restype = None
    return c_Clear(globalDefReaderCallbacks)

def _callback_wrapper(type, func, convert_args=None):
    def wrapper(userData, *args):
        if userData:
            py_userData = ctypes.cast(userData, ctypes.py_object).value
        else:
            py_userData = None
        try:
            if convert_args is not None:
                args = convert_args(*args)
            ret = func(py_userData, *args)
            if ret is None:
                ret = CALLBACK_SUCCESS
        except:
            sys.stderr.write("An unhandled python exception has occurred in an "
                             "OTF2_GlobalDefReaderCallback:\n")
            sys.stderr.write(traceback.format_exc())
            ret = CALLBACK_ERROR
        return ret.value
    return callback_wrapper(func, wrapper, type)

def _convert_property_union(refered_def, name, type, value):
    union = AttributeValue()
    union._arg_value = value
    return refered_def, name, type, union

_GlobalDefReaderCallback_FP_Unknown = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p)

_GlobalDefReaderCallback_FP_ClockProperties = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_uint64)

_GlobalDefReaderCallback_FP_Paradigm = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, Paradigm, StringRef, ParadigmClass)

_GlobalDefReaderCallback_FP_ParadigmProperty = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, Paradigm, ParadigmProperty, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_IoParadigm = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, IoParadigmRef, StringRef, StringRef, IoParadigmClass, IoParadigmFlag, ctypes.c_uint8, ctypes.POINTER(IoParadigmProperty), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue))

_GlobalDefReaderCallback_FP_String = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, StringRef, ctypes.c_char_p)

_GlobalDefReaderCallback_FP_Attribute = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, AttributeRef, StringRef, StringRef, Type)

_GlobalDefReaderCallback_FP_SystemTreeNode = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, SystemTreeNodeRef, StringRef, StringRef, SystemTreeNodeRef)

_GlobalDefReaderCallback_FP_LocationGroup = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, LocationGroupRef, StringRef, LocationGroupType, SystemTreeNodeRef, LocationGroupRef)

_GlobalDefReaderCallback_FP_Location = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, LocationRef, StringRef, LocationType, ctypes.c_uint64, LocationGroupRef)

_GlobalDefReaderCallback_FP_Region = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, RegionRef, StringRef, StringRef, StringRef, RegionRole, Paradigm, RegionFlag, StringRef, ctypes.c_uint32, ctypes.c_uint32)

_GlobalDefReaderCallback_FP_Callsite = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CallsiteRef, StringRef, ctypes.c_uint32, RegionRef, RegionRef)

_GlobalDefReaderCallback_FP_Callpath = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CallpathRef, CallpathRef, RegionRef)

_GlobalDefReaderCallback_FP_Group = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, GroupRef, StringRef, GroupType, Paradigm, GroupFlag, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint64))

_GlobalDefReaderCallback_FP_MetricMember = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, MetricMemberRef, StringRef, StringRef, MetricType, MetricMode, Type, Base, ctypes.c_int64, StringRef)

_GlobalDefReaderCallback_FP_MetricClass = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, MetricRef, ctypes.c_uint8, ctypes.POINTER(MetricMemberRef), MetricOccurrence, RecorderKind)

_GlobalDefReaderCallback_FP_MetricInstance = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, MetricRef, MetricRef, LocationRef, MetricScope, ctypes.c_uint64)

_GlobalDefReaderCallback_FP_Comm = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CommRef, StringRef, GroupRef, CommRef, CommFlag)

_GlobalDefReaderCallback_FP_Parameter = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, ParameterRef, StringRef, ParameterType)

_GlobalDefReaderCallback_FP_RmaWin = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, RmaWinRef, StringRef, CommRef, RmaWinFlag)

_GlobalDefReaderCallback_FP_MetricClassRecorder = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, MetricRef, LocationRef)

_GlobalDefReaderCallback_FP_SystemTreeNodeProperty = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, SystemTreeNodeRef, StringRef, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_SystemTreeNodeDomain = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, SystemTreeNodeRef, SystemTreeDomain)

_GlobalDefReaderCallback_FP_LocationGroupProperty = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, LocationGroupRef, StringRef, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_LocationProperty = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, LocationRef, StringRef, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_CartDimension = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CartDimensionRef, StringRef, ctypes.c_uint32, CartPeriodicity)

_GlobalDefReaderCallback_FP_CartTopology = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CartTopologyRef, StringRef, CommRef, ctypes.c_uint8, ctypes.POINTER(CartDimensionRef))

_GlobalDefReaderCallback_FP_CartCoordinate = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CartTopologyRef, ctypes.c_uint32, ctypes.c_uint8, ctypes.POINTER(ctypes.c_uint32))

_GlobalDefReaderCallback_FP_SourceCodeLocation = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, SourceCodeLocationRef, StringRef, ctypes.c_uint32)

_GlobalDefReaderCallback_FP_CallingContext = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CallingContextRef, RegionRef, SourceCodeLocationRef, CallingContextRef)

_GlobalDefReaderCallback_FP_CallingContextProperty = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CallingContextRef, StringRef, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_InterruptGenerator = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, InterruptGeneratorRef, StringRef, InterruptGeneratorMode, Base, ctypes.c_int64, ctypes.c_uint64)

_GlobalDefReaderCallback_FP_IoFileProperty = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, IoFileRef, StringRef, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_IoRegularFile = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, IoFileRef, StringRef, SystemTreeNodeRef)

_GlobalDefReaderCallback_FP_IoDirectory = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, IoFileRef, StringRef, SystemTreeNodeRef)

_GlobalDefReaderCallback_FP_IoHandle = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, IoHandleRef, StringRef, IoFileRef, IoParadigmRef, IoHandleFlag, CommRef, IoHandleRef)

_GlobalDefReaderCallback_FP_IoPreCreatedHandleState = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, IoHandleRef, IoAccessMode, IoStatusFlag)

_GlobalDefReaderCallback_FP_CallpathParameter = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CallpathRef, ParameterRef, Type, AttributeValue._arg_type)

_GlobalDefReaderCallback_FP_InterComm = ctypes.CFUNCTYPE(CallbackCode, ctypes.c_void_p, CommRef, StringRef, GroupRef, GroupRef, CommRef, CommFlag)

def GlobalDefReaderCallbacks_SetUnknownCallback(globalDefReaderCallbacks, unknownCallback):
    c_SetUnknownCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetUnknownCallback
    c_SetUnknownCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Unknown ]
    c_SetUnknownCallback.restype = ErrorCode
    c_SetUnknownCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Unknown,
                                         unknownCallback)
    c_SetUnknownCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetClockPropertiesCallback(globalDefReaderCallbacks, clockPropertiesCallback):
    c_SetClockPropertiesCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetClockPropertiesCallback
    c_SetClockPropertiesCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_ClockProperties ]
    c_SetClockPropertiesCallback.restype = ErrorCode
    c_SetClockPropertiesCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_ClockProperties,
                                         clockPropertiesCallback,
                                         convert)
    c_SetClockPropertiesCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetParadigmCallback(globalDefReaderCallbacks, paradigmCallback):
    c_SetParadigmCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetParadigmCallback
    c_SetParadigmCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Paradigm ]
    c_SetParadigmCallback.restype = ErrorCode
    c_SetParadigmCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Paradigm,
                                         paradigmCallback,
                                         convert)
    c_SetParadigmCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetParadigmPropertyCallback(globalDefReaderCallbacks, paradigmPropertyCallback):
    c_SetParadigmPropertyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetParadigmPropertyCallback
    c_SetParadigmPropertyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_ParadigmProperty ]
    c_SetParadigmPropertyCallback.restype = ErrorCode
    c_SetParadigmPropertyCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_ParadigmProperty,
                                         paradigmPropertyCallback,
                                         convert)
    c_SetParadigmPropertyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetIoParadigmCallback(globalDefReaderCallbacks, ioParadigmCallback):
    c_SetIoParadigmCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetIoParadigmCallback
    c_SetIoParadigmCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_IoParadigm ]
    c_SetIoParadigmCallback.restype = ErrorCode
    c_SetIoParadigmCallback.errcheck = HandleErrorCode
    def convert_property(ref, identification, name, io_paradigm_class, io_paradigm_flags, \
                         number_of_properties, properties_array, types_array, values_array):
        properties = [properties_array[i] for i in range(number_of_properties)]
        types = [types_array[i] for i in range(number_of_properties)]
        values = [values_array[i] for i in range(number_of_properties)]
        return ref, identification, name, io_paradigm_class, io_paradigm_flags, properties, \
               types, values
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_IoParadigm,
                                         ioParadigmCallback, convert_property)
    c_SetIoParadigmCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetStringCallback(globalDefReaderCallbacks, stringCallback):
    c_SetStringCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetStringCallback
    c_SetStringCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_String ]
    c_SetStringCallback.restype = ErrorCode
    c_SetStringCallback.errcheck = HandleErrorCode
    def convert_string(ref, name):
        return ref, str_decode(name)
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_String,
                                         stringCallback, convert_string)
    c_SetStringCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetAttributeCallback(globalDefReaderCallbacks, attributeCallback):
    c_SetAttributeCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetAttributeCallback
    c_SetAttributeCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Attribute ]
    c_SetAttributeCallback.restype = ErrorCode
    c_SetAttributeCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Attribute,
                                         attributeCallback,
                                         convert)
    c_SetAttributeCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetSystemTreeNodeCallback(globalDefReaderCallbacks, systemTreeNodeCallback):
    c_SetSystemTreeNodeCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetSystemTreeNodeCallback
    c_SetSystemTreeNodeCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_SystemTreeNode ]
    c_SetSystemTreeNodeCallback.restype = ErrorCode
    c_SetSystemTreeNodeCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_SystemTreeNode,
                                         systemTreeNodeCallback,
                                         convert)
    c_SetSystemTreeNodeCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetLocationGroupCallback(globalDefReaderCallbacks, locationGroupCallback):
    c_SetLocationGroupCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetLocationGroupCallback
    c_SetLocationGroupCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_LocationGroup ]
    c_SetLocationGroupCallback.restype = ErrorCode
    c_SetLocationGroupCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_LocationGroup,
                                         locationGroupCallback,
                                         convert)
    c_SetLocationGroupCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetLocationCallback(globalDefReaderCallbacks, locationCallback):
    c_SetLocationCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetLocationCallback
    c_SetLocationCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Location ]
    c_SetLocationCallback.restype = ErrorCode
    c_SetLocationCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Location,
                                         locationCallback,
                                         convert)
    c_SetLocationCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetRegionCallback(globalDefReaderCallbacks, regionCallback):
    c_SetRegionCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetRegionCallback
    c_SetRegionCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Region ]
    c_SetRegionCallback.restype = ErrorCode
    c_SetRegionCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Region,
                                         regionCallback,
                                         convert)
    c_SetRegionCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCallsiteCallback(globalDefReaderCallbacks, callsiteCallback):
    c_SetCallsiteCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCallsiteCallback
    c_SetCallsiteCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Callsite ]
    c_SetCallsiteCallback.restype = ErrorCode
    c_SetCallsiteCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Callsite,
                                         callsiteCallback,
                                         convert)
    c_SetCallsiteCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCallpathCallback(globalDefReaderCallbacks, callpathCallback):
    c_SetCallpathCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCallpathCallback
    c_SetCallpathCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Callpath ]
    c_SetCallpathCallback.restype = ErrorCode
    c_SetCallpathCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Callpath,
                                         callpathCallback,
                                         convert)
    c_SetCallpathCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetGroupCallback(globalDefReaderCallbacks, groupCallback):
    c_SetGroupCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetGroupCallback
    c_SetGroupCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Group ]
    c_SetGroupCallback.restype = ErrorCode
    c_SetGroupCallback.errcheck = HandleErrorCode
    def convert_group(ref, name, group_type, paradigm, group_flags, number_of_metrics,
                      members_array):
        members = [members_array[i] for i in range(number_of_metrics)]
        return ref, name, group_type, paradigm, group_flags, members
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Group,
                                         groupCallback, convert_group)
    c_SetGroupCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetMetricMemberCallback(globalDefReaderCallbacks, metricMemberCallback):
    c_SetMetricMemberCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetMetricMemberCallback
    c_SetMetricMemberCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_MetricMember ]
    c_SetMetricMemberCallback.restype = ErrorCode
    c_SetMetricMemberCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_MetricMember,
                                         metricMemberCallback,
                                         convert)
    c_SetMetricMemberCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetMetricClassCallback(globalDefReaderCallbacks, metricClassCallback):
    c_SetMetricClassCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetMetricClassCallback
    c_SetMetricClassCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_MetricClass ]
    c_SetMetricClassCallback.restype = ErrorCode
    c_SetMetricClassCallback.errcheck = HandleErrorCode
    def convert_metric_class(ref, number_of_metrics, metric_members_array, metric_occurrence,
                             recorder_kind):
        metric_members = [metric_members_array[i] for i in range(number_of_metrics)]
        return ref, metric_members, metric_occurrence, recorder_kind
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_MetricClass,
                                         metricClassCallback, convert_metric_class)
    c_SetMetricClassCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetMetricInstanceCallback(globalDefReaderCallbacks, metricInstanceCallback):
    c_SetMetricInstanceCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetMetricInstanceCallback
    c_SetMetricInstanceCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_MetricInstance ]
    c_SetMetricInstanceCallback.restype = ErrorCode
    c_SetMetricInstanceCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_MetricInstance,
                                         metricInstanceCallback,
                                         convert)
    c_SetMetricInstanceCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCommCallback(globalDefReaderCallbacks, commCallback):
    c_SetCommCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCommCallback
    c_SetCommCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Comm ]
    c_SetCommCallback.restype = ErrorCode
    c_SetCommCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Comm,
                                         commCallback,
                                         convert)
    c_SetCommCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetParameterCallback(globalDefReaderCallbacks, parameterCallback):
    c_SetParameterCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetParameterCallback
    c_SetParameterCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_Parameter ]
    c_SetParameterCallback.restype = ErrorCode
    c_SetParameterCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_Parameter,
                                         parameterCallback,
                                         convert)
    c_SetParameterCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetRmaWinCallback(globalDefReaderCallbacks, rmaWinCallback):
    c_SetRmaWinCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetRmaWinCallback
    c_SetRmaWinCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_RmaWin ]
    c_SetRmaWinCallback.restype = ErrorCode
    c_SetRmaWinCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_RmaWin,
                                         rmaWinCallback,
                                         convert)
    c_SetRmaWinCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetMetricClassRecorderCallback(globalDefReaderCallbacks, metricClassRecorderCallback):
    c_SetMetricClassRecorderCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetMetricClassRecorderCallback
    c_SetMetricClassRecorderCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_MetricClassRecorder ]
    c_SetMetricClassRecorderCallback.restype = ErrorCode
    c_SetMetricClassRecorderCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_MetricClassRecorder,
                                         metricClassRecorderCallback,
                                         convert)
    c_SetMetricClassRecorderCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetSystemTreeNodePropertyCallback(globalDefReaderCallbacks, systemTreeNodePropertyCallback):
    c_SetSystemTreeNodePropertyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetSystemTreeNodePropertyCallback
    c_SetSystemTreeNodePropertyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_SystemTreeNodeProperty ]
    c_SetSystemTreeNodePropertyCallback.restype = ErrorCode
    c_SetSystemTreeNodePropertyCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_SystemTreeNodeProperty,
                                         systemTreeNodePropertyCallback,
                                         convert)
    c_SetSystemTreeNodePropertyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetSystemTreeNodeDomainCallback(globalDefReaderCallbacks, systemTreeNodeDomainCallback):
    c_SetSystemTreeNodeDomainCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetSystemTreeNodeDomainCallback
    c_SetSystemTreeNodeDomainCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_SystemTreeNodeDomain ]
    c_SetSystemTreeNodeDomainCallback.restype = ErrorCode
    c_SetSystemTreeNodeDomainCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_SystemTreeNodeDomain,
                                         systemTreeNodeDomainCallback,
                                         convert)
    c_SetSystemTreeNodeDomainCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetLocationGroupPropertyCallback(globalDefReaderCallbacks, locationGroupPropertyCallback):
    c_SetLocationGroupPropertyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetLocationGroupPropertyCallback
    c_SetLocationGroupPropertyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_LocationGroupProperty ]
    c_SetLocationGroupPropertyCallback.restype = ErrorCode
    c_SetLocationGroupPropertyCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_LocationGroupProperty,
                                         locationGroupPropertyCallback,
                                         convert)
    c_SetLocationGroupPropertyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetLocationPropertyCallback(globalDefReaderCallbacks, locationPropertyCallback):
    c_SetLocationPropertyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetLocationPropertyCallback
    c_SetLocationPropertyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_LocationProperty ]
    c_SetLocationPropertyCallback.restype = ErrorCode
    c_SetLocationPropertyCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_LocationProperty,
                                         locationPropertyCallback,
                                         convert)
    c_SetLocationPropertyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCartDimensionCallback(globalDefReaderCallbacks, cartDimensionCallback):
    c_SetCartDimensionCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCartDimensionCallback
    c_SetCartDimensionCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_CartDimension ]
    c_SetCartDimensionCallback.restype = ErrorCode
    c_SetCartDimensionCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_CartDimension,
                                         cartDimensionCallback,
                                         convert)
    c_SetCartDimensionCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCartTopologyCallback(globalDefReaderCallbacks, cartTopologyCallback):
    c_SetCartTopologyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCartTopologyCallback
    c_SetCartTopologyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_CartTopology ]
    c_SetCartTopologyCallback.restype = ErrorCode
    c_SetCartTopologyCallback.errcheck = HandleErrorCode
    def convert_cart_topology(ref, name, communicator, number_of_dimensions,
                              cart_dimensions_array):
        cart_dimensions = [cart_dimensions_array[i] for i in range(number_of_dimensions)]
        return ref, name, communicator, cart_dimensions
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_CartTopology,
                                         cartTopologyCallback, convert_cart_topology)
    c_SetCartTopologyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCartCoordinateCallback(globalDefReaderCallbacks, cartCoordinateCallback):
    c_SetCartCoordinateCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCartCoordinateCallback
    c_SetCartCoordinateCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_CartCoordinate ]
    c_SetCartCoordinateCallback.restype = ErrorCode
    c_SetCartCoordinateCallback.errcheck = HandleErrorCode
    def convert_cart_coordinate(cart_topology, rank, number_of_dimensions, coordinates_array):
        coordinates = [coordinates_array[i] for i in range(number_of_dimensions)]
        return cart_topology, rank, coordinates
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_CartCoordinate,
                                         cartCoordinateCallback, convert_cart_coordinate)
    c_SetCartCoordinateCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetSourceCodeLocationCallback(globalDefReaderCallbacks, sourceCodeLocationCallback):
    c_SetSourceCodeLocationCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetSourceCodeLocationCallback
    c_SetSourceCodeLocationCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_SourceCodeLocation ]
    c_SetSourceCodeLocationCallback.restype = ErrorCode
    c_SetSourceCodeLocationCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_SourceCodeLocation,
                                         sourceCodeLocationCallback,
                                         convert)
    c_SetSourceCodeLocationCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCallingContextCallback(globalDefReaderCallbacks, callingContextCallback):
    c_SetCallingContextCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCallingContextCallback
    c_SetCallingContextCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_CallingContext ]
    c_SetCallingContextCallback.restype = ErrorCode
    c_SetCallingContextCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_CallingContext,
                                         callingContextCallback,
                                         convert)
    c_SetCallingContextCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCallingContextPropertyCallback(globalDefReaderCallbacks, callingContextPropertyCallback):
    c_SetCallingContextPropertyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCallingContextPropertyCallback
    c_SetCallingContextPropertyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_CallingContextProperty ]
    c_SetCallingContextPropertyCallback.restype = ErrorCode
    c_SetCallingContextPropertyCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_CallingContextProperty,
                                         callingContextPropertyCallback,
                                         convert)
    c_SetCallingContextPropertyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetInterruptGeneratorCallback(globalDefReaderCallbacks, interruptGeneratorCallback):
    c_SetInterruptGeneratorCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetInterruptGeneratorCallback
    c_SetInterruptGeneratorCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_InterruptGenerator ]
    c_SetInterruptGeneratorCallback.restype = ErrorCode
    c_SetInterruptGeneratorCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_InterruptGenerator,
                                         interruptGeneratorCallback,
                                         convert)
    c_SetInterruptGeneratorCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetIoFilePropertyCallback(globalDefReaderCallbacks, ioFilePropertyCallback):
    c_SetIoFilePropertyCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetIoFilePropertyCallback
    c_SetIoFilePropertyCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_IoFileProperty ]
    c_SetIoFilePropertyCallback.restype = ErrorCode
    c_SetIoFilePropertyCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_IoFileProperty,
                                         ioFilePropertyCallback,
                                         convert)
    c_SetIoFilePropertyCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetIoRegularFileCallback(globalDefReaderCallbacks, ioRegularFileCallback):
    c_SetIoRegularFileCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetIoRegularFileCallback
    c_SetIoRegularFileCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_IoRegularFile ]
    c_SetIoRegularFileCallback.restype = ErrorCode
    c_SetIoRegularFileCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_IoRegularFile,
                                         ioRegularFileCallback,
                                         convert)
    c_SetIoRegularFileCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetIoDirectoryCallback(globalDefReaderCallbacks, ioDirectoryCallback):
    c_SetIoDirectoryCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetIoDirectoryCallback
    c_SetIoDirectoryCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_IoDirectory ]
    c_SetIoDirectoryCallback.restype = ErrorCode
    c_SetIoDirectoryCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_IoDirectory,
                                         ioDirectoryCallback,
                                         convert)
    c_SetIoDirectoryCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetIoHandleCallback(globalDefReaderCallbacks, ioHandleCallback):
    c_SetIoHandleCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetIoHandleCallback
    c_SetIoHandleCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_IoHandle ]
    c_SetIoHandleCallback.restype = ErrorCode
    c_SetIoHandleCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_IoHandle,
                                         ioHandleCallback,
                                         convert)
    c_SetIoHandleCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetIoPreCreatedHandleStateCallback(globalDefReaderCallbacks, ioPreCreatedHandleStateCallback):
    c_SetIoPreCreatedHandleStateCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetIoPreCreatedHandleStateCallback
    c_SetIoPreCreatedHandleStateCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_IoPreCreatedHandleState ]
    c_SetIoPreCreatedHandleStateCallback.restype = ErrorCode
    c_SetIoPreCreatedHandleStateCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_IoPreCreatedHandleState,
                                         ioPreCreatedHandleStateCallback,
                                         convert)
    c_SetIoPreCreatedHandleStateCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetCallpathParameterCallback(globalDefReaderCallbacks, callpathParameterCallback):
    c_SetCallpathParameterCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetCallpathParameterCallback
    c_SetCallpathParameterCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_CallpathParameter ]
    c_SetCallpathParameterCallback.restype = ErrorCode
    c_SetCallpathParameterCallback.errcheck = HandleErrorCode
    convert = _convert_property_union
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_CallpathParameter,
                                         callpathParameterCallback,
                                         convert)
    c_SetCallpathParameterCallback(globalDefReaderCallbacks, wrapped_callback)

def GlobalDefReaderCallbacks_SetInterCommCallback(globalDefReaderCallbacks, interCommCallback):
    c_SetInterCommCallback = conf.lib.OTF2_GlobalDefReaderCallbacks_SetInterCommCallback
    c_SetInterCommCallback.argtypes = [ ctypes.POINTER(GlobalDefReaderCallbacks), _GlobalDefReaderCallback_FP_InterComm ]
    c_SetInterCommCallback.restype = ErrorCode
    c_SetInterCommCallback.errcheck = HandleErrorCode
    convert = None
    wrapped_callback = _callback_wrapper(_GlobalDefReaderCallback_FP_InterComm,
                                         interCommCallback,
                                         convert)
    c_SetInterCommCallback(globalDefReaderCallbacks, wrapped_callback)

__all__ = [
    'GlobalDefReaderCallbacks',
    'GlobalDefReaderCallbacks_New',
    'GlobalDefReaderCallbacks_Delete',
    'GlobalDefReaderCallbacks_Clear',
    'GlobalDefReaderCallbacks_SetUnknownCallback',
    'GlobalDefReaderCallbacks_SetClockPropertiesCallback',
    'GlobalDefReaderCallbacks_SetParadigmCallback',
    'GlobalDefReaderCallbacks_SetParadigmPropertyCallback',
    'GlobalDefReaderCallbacks_SetIoParadigmCallback',
    'GlobalDefReaderCallbacks_SetStringCallback',
    'GlobalDefReaderCallbacks_SetAttributeCallback',
    'GlobalDefReaderCallbacks_SetSystemTreeNodeCallback',
    'GlobalDefReaderCallbacks_SetLocationGroupCallback',
    'GlobalDefReaderCallbacks_SetLocationCallback',
    'GlobalDefReaderCallbacks_SetRegionCallback',
    'GlobalDefReaderCallbacks_SetCallsiteCallback',
    'GlobalDefReaderCallbacks_SetCallpathCallback',
    'GlobalDefReaderCallbacks_SetGroupCallback',
    'GlobalDefReaderCallbacks_SetMetricMemberCallback',
    'GlobalDefReaderCallbacks_SetMetricClassCallback',
    'GlobalDefReaderCallbacks_SetMetricInstanceCallback',
    'GlobalDefReaderCallbacks_SetCommCallback',
    'GlobalDefReaderCallbacks_SetParameterCallback',
    'GlobalDefReaderCallbacks_SetRmaWinCallback',
    'GlobalDefReaderCallbacks_SetMetricClassRecorderCallback',
    'GlobalDefReaderCallbacks_SetSystemTreeNodePropertyCallback',
    'GlobalDefReaderCallbacks_SetSystemTreeNodeDomainCallback',
    'GlobalDefReaderCallbacks_SetLocationGroupPropertyCallback',
    'GlobalDefReaderCallbacks_SetLocationPropertyCallback',
    'GlobalDefReaderCallbacks_SetCartDimensionCallback',
    'GlobalDefReaderCallbacks_SetCartTopologyCallback',
    'GlobalDefReaderCallbacks_SetCartCoordinateCallback',
    'GlobalDefReaderCallbacks_SetSourceCodeLocationCallback',
    'GlobalDefReaderCallbacks_SetCallingContextCallback',
    'GlobalDefReaderCallbacks_SetCallingContextPropertyCallback',
    'GlobalDefReaderCallbacks_SetInterruptGeneratorCallback',
    'GlobalDefReaderCallbacks_SetIoFilePropertyCallback',
    'GlobalDefReaderCallbacks_SetIoRegularFileCallback',
    'GlobalDefReaderCallbacks_SetIoDirectoryCallback',
    'GlobalDefReaderCallbacks_SetIoHandleCallback',
    'GlobalDefReaderCallbacks_SetIoPreCreatedHandleStateCallback',
    'GlobalDefReaderCallbacks_SetCallpathParameterCallback',
    'GlobalDefReaderCallbacks_SetInterCommCallback',
]
