/* SPDX-License-Identifier: GPL-2.0-or-later */
/* IRQ mode has not been tested. */

Name (AR00, Package() {
	// D31
	Package(){0x001FFFFF, 0, 0, 16 },
	Package(){0x001FFFFF, 1, 0, 17 },
	Package(){0x001FFFFF, 2, 0, 18 },
	Package(){0x001FFFFF, 3, 0, 19 },
	// D30
	Package(){0x001EFFFF, 0, 0, 16 },
	Package(){0x001EFFFF, 1, 0, 17 },
	Package(){0x001EFFFF, 2, 0, 18 },
	Package(){0x001EFFFF, 3, 0, 19 },
	// D29
	Package(){0x001DFFFF, 0, 0, 16 },
	Package(){0x001DFFFF, 1, 0, 17 },
	Package(){0x001DFFFF, 2, 0, 18 },
	Package(){0x001DFFFF, 3, 0, 19 },
	// D28
	Package(){0x001CFFFF, 0, 0, 16 },
	Package(){0x001CFFFF, 1, 0, 17 },
	Package(){0x001CFFFF, 2, 0, 18 },
	Package(){0x001CFFFF, 3, 0, 19 },
	// D27
	Package(){0x001BFFFF, 0, 0, 16 },
	Package(){0x001BFFFF, 1, 0, 17 },
	Package(){0x001BFFFF, 2, 0, 18 },
	Package(){0x001BFFFF, 3, 0, 19 },
	// D26
	Package(){0x001AFFFF, 0, 0, 16 },
	Package(){0x001AFFFF, 1, 0, 17 },
	Package(){0x001AFFFF, 2, 0, 18 },
	Package(){0x001AFFFF, 3, 0, 19 },
	// D25
	Package(){0x0019FFFF, 0, 0, 16 },
	Package(){0x0019FFFF, 1, 0, 17 },
	Package(){0x0019FFFF, 2, 0, 18 },
	Package(){0x0019FFFF, 3, 0, 19 },
	// D24
	Package(){0x0018FFFF, 0, 0, 16 },
	Package(){0x0018FFFF, 1, 0, 17 },
	Package(){0x0018FFFF, 2, 0, 18 },
	Package(){0x0018FFFF, 3, 0, 19 },
	// D23
	Package(){0x0017FFFF, 0, 0, 16 },
	Package(){0x0017FFFF, 1, 0, 17 },
	Package(){0x0017FFFF, 2, 0, 18 },
	Package(){0x0017FFFF, 3, 0, 19 },
	// D22
	Package(){0x0016FFFF, 0, 0, 16 },
	Package(){0x0016FFFF, 1, 0, 17 },
	Package(){0x0016FFFF, 2, 0, 18 },
	Package(){0x0016FFFF, 3, 0, 19 },
	// D21
	Package(){0x0015FFFF, 0, 0, 16 },
	Package(){0x0015FFFF, 1, 0, 17 },
	Package(){0x0015FFFF, 2, 0, 18 },
	Package(){0x0015FFFF, 3, 0, 19 },
	// D20
	Package(){0x0014FFFF, 0, 0, 16 },
	Package(){0x0014FFFF, 1, 0, 17 },
	Package(){0x0014FFFF, 2, 0, 18 },
	Package(){0x0014FFFF, 3, 0, 19 },
	// D19
	Package(){0x0013FFFF, 0, 0, 16 },
	Package(){0x0013FFFF, 1, 0, 17 },
	Package(){0x0013FFFF, 2, 0, 18 },
	Package(){0x0013FFFF, 3, 0, 19 },
	// D18
	Package(){0x0012FFFF, 0, 0, 16 },
	Package(){0x0012FFFF, 1, 0, 17 },
	Package(){0x0012FFFF, 2, 0, 18 },
	Package(){0x0012FFFF, 3, 0, 19 },
	// D17
	Package(){0x0011FFFF, 0, 0, 16 },
	Package(){0x0011FFFF, 1, 0, 17 },
	Package(){0x0011FFFF, 2, 0, 18 },
	Package(){0x0011FFFF, 3, 0, 19 },
	// D16
	Package(){0x0010FFFF, 0, 0, 16 },
	Package(){0x0010FFFF, 1, 0, 17 },
	Package(){0x0010FFFF, 2, 0, 18 },
	Package(){0x0010FFFF, 3, 0, 19 },
	// D15
	Package(){0x000FFFFF, 0, 0, 16 },
	Package(){0x000FFFFF, 1, 0, 17 },
	Package(){0x000FFFFF, 2, 0, 18 },
	Package(){0x000FFFFF, 3, 0, 19 },
	// D14
	Package(){0x000EFFFF, 0, 0, 16 },
	Package(){0x000EFFFF, 1, 0, 17 },
	Package(){0x000EFFFF, 2, 0, 18 },
	Package(){0x000EFFFF, 3, 0, 19 },
	// D13
	Package(){0x000DFFFF, 0, 0, 16 },
	Package(){0x000DFFFF, 1, 0, 17 },
	Package(){0x000DFFFF, 2, 0, 18 },
	Package(){0x000DFFFF, 3, 0, 19 },
	// D12
	Package(){0x000CFFFF, 0, 0, 16 },
	Package(){0x000CFFFF, 1, 0, 17 },
	Package(){0x000CFFFF, 2, 0, 18 },
	Package(){0x000CFFFF, 3, 0, 19 },
	// D11
	Package(){0x000BFFFF, 0, 0, 16 },
	Package(){0x000BFFFF, 1, 0, 17 },
	Package(){0x000BFFFF, 2, 0, 18 },
	Package(){0x000BFFFF, 3, 0, 19 },
	// D10
	Package(){0x000AFFFF, 0, 0, 16 },
	Package(){0x000AFFFF, 1, 0, 17 },
	Package(){0x000AFFFF, 2, 0, 18 },
	Package(){0x000AFFFF, 3, 0, 19 },
	// D9
	Package(){0x0009FFFF, 0, 0, 16 },
	Package(){0x0009FFFF, 1, 0, 17 },
	Package(){0x0009FFFF, 2, 0, 18 },
	Package(){0x0009FFFF, 3, 0, 19 },
	// D8
	Package(){0x0008FFFF, 0, 0, 16 },
	Package(){0x0008FFFF, 1, 0, 17 },
	Package(){0x0008FFFF, 2, 0, 18 },
	Package(){0x0008FFFF, 3, 0, 19 },

	// [IIM0]: IIOMISC on PC00
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
	// [RLK0]: Legacy PCI Express Port 0 on PC00
	Package() { 0x0003FFFF, 0, 0, 16 },
	Package() { 0x0007FFFF, 0, 0, 16 },
})

Name (AR01, Package() {
	// [IIM0]: IIOMISC on PCxx(non PC00)
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
	// [BRPA]: PCI Express Port A
	Package() { 0x0001FFFF, 0, 0, 16 },
	Package() { 0x0001FFFF, 1, 0, 17 },
	Package() { 0x0001FFFF, 2, 0, 18 },
	Package() { 0x0001FFFF, 3, 0, 19 },
	// [BRPB]: PCI Express Port B
	Package() { 0x0002FFFF, 0, 0, 16 },
	Package() { 0x0002FFFF, 1, 0, 17 },
	Package() { 0x0002FFFF, 2, 0, 18 },
	Package() { 0x0002FFFF, 3, 0, 19 },
	// [BRPC]: PCI Express Port C
	Package() { 0x0003FFFF, 0, 0, 16 },
	Package() { 0x0003FFFF, 1, 0, 17 },
	Package() { 0x0003FFFF, 2, 0, 18 },
	Package() { 0x0003FFFF, 3, 0, 19 },
	// [BRPD]: PCI Express Port D
	Package() { 0x0004FFFF, 0, 0, 16 },
	Package() { 0x0004FFFF, 1, 0, 17 },
	Package() { 0x0004FFFF, 2, 0, 18 },
	Package() { 0x0004FFFF, 3, 0, 19 },
	// [BRPE]: PCI Express Port E
	Package() { 0x0005FFFF, 0, 0, 16 },
	Package() { 0x0005FFFF, 1, 0, 17 },
	Package() { 0x0005FFFF, 2, 0, 18 },
	Package() { 0x0005FFFF, 3, 0, 19 },
	// [BRPF]: PCI Express Port F
	Package() { 0x0006FFFF, 0, 0, 16 },
	Package() { 0x0006FFFF, 1, 0, 17 },
	Package() { 0x0006FFFF, 2, 0, 18 },
	Package() { 0x0006FFFF, 3, 0, 19 },
	// [BRPG]: PCI Express Port G
	Package() { 0x0007FFFF, 0, 0, 16 },
	Package() { 0x0007FFFF, 1, 0, 17 },
	Package() { 0x0007FFFF, 2, 0, 18 },
	Package() { 0x0007FFFF, 3, 0, 19 },
	// [BRPH]: PCI Express Port H
	Package() { 0x0008FFFF, 0, 0, 16 },
	Package() { 0x0008FFFF, 1, 0, 17 },
	Package() { 0x0008FFFF, 2, 0, 18 },
	Package() { 0x0008FFFF, 3, 0, 19 },
	// [NTBR]: NTB IRQ routing table
	Package() { 0x0009FFFF, 0, 0, 16 },
	Package() { 0x0009FFFF, 1, 0, 17 },
	Package() { 0x0009FFFF, 2, 0, 18 },
	Package() { 0x0009FFFF, 3, 0, 19 },
	// D23: SATA Port 0
	Package() { 0x0017FFFF, 0, 0, 16 },
	Package() { 0x0017FFFF, 1, 0, 17 },
	Package() { 0x0017FFFF, 2, 0, 18 },
	Package() { 0x0017FFFF, 3, 0, 19 },
	// D24: SATA Port 1
	Package() { 0x0018FFFF, 0, 0, 16 },
	Package() { 0x0018FFFF, 1, 0, 17 },
	Package() { 0x0018FFFF, 2, 0, 18 },
	Package() { 0x0018FFFF, 3, 0, 19 },
	// D25: SATA Port 2
	Package() { 0x0019FFFF, 0, 0, 16 },
	Package() { 0x0019FFFF, 1, 0, 17 },
	Package() { 0x0019FFFF, 2, 0, 18 },
	Package() { 0x0019FFFF, 3, 0, 19 },
	// D31: PCH devices
	Package() { 0x001FFFFF, 0, 0, 16 },
	Package() { 0x001FFFFF, 1, 0, 17 },
	Package() { 0x001FFFFF, 2, 0, 18 },
	Package() { 0x001FFFFF, 3, 0, 19 },
})

Name (AR02, Package() {
	// [BRPA]: PCI Express Port A
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR03, Package() {
	// [BRPB]: PCI Express Port B
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR04, Package() {
	// [BRPC]: PCI Express Port C
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR05, Package() {
	// [BRPD]: PCI Express Port D
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR06, Package() {
	// [BRPE]: PCI Express Port E
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR07, Package() {
	// [BRPF]: PCI Express Port F
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR08, Package() {
	// [BRPG]: PCI Express Port G
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR09, Package() {
	// [BRPH]: PCI Express Port H
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})

Name (AR0A, Package() {
	// [NTBR]: NTB IRQ routing table
	Package() { 0x0009FFFF, 0, 0, 16 },
	Package() { 0x0009FFFF, 1, 0, 17 },
	Package() { 0x0009FFFF, 2, 0, 18 },
	Package() { 0x0009FFFF, 3, 0, 19 },
})

Name (AR10, Package() {
	// [UBX0]: Uncore 0 UBOX Device
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
	// [CSM0]: Uncore 0 CHASIS_SMBUS Devices
	Package() { 0x000BFFFF, 0, 0, 16 },
	Package() { 0x000BFFFF, 1, 0, 17 },
	Package() { 0x000BFFFF, 2, 0, 18 },
	Package() { 0x000BFFFF, 3, 0, 19 },
	// [M2M0]: Uncore 0 MS2MEM_SCF_MS2MEM0 Device
	Package() { 0x000CFFFF, 0, 0, 16 },
	Package() { 0x000CFFFF, 1, 0, 17 },
	Package() { 0x000CFFFF, 2, 0, 18 },
	Package() { 0x000CFFFF, 3, 0, 19 },
	// [M2M1]: Uncore 0 MS2MEM_SCF_MS2MEM1 Device
	Package() { 0x000DFFFF, 0, 0, 16 },
	Package() { 0x000DFFFF, 1, 0, 17 },
	Package() { 0x000DFFFF, 2, 0, 18 },
	Package() { 0x000DFFFF, 3, 0, 19 },
	// [MCD0]: Uncore 0 MCDDR0 Device
	Package() { 0x001AFFFF, 0, 0, 16 },
	Package() { 0x001AFFFF, 1, 0, 17 },
	Package() { 0x001AFFFF, 2, 0, 18 },
	Package() { 0x001AFFFF, 3, 0, 19 },
	// [MCD1]: Uncore 0 MCDDR1 Device
	Package() { 0x001BFFFF, 0, 0, 16 },
	Package() { 0x001BFFFF, 1, 0, 17 },
	Package() { 0x001BFFFF, 2, 0, 18 },
	Package() { 0x001BFFFF, 3, 0, 19 },
})

Name (AR11, Package() {
	// [CHA1]: Uncore 1 GRP1_CHA8-10 Device
	Package() { 0x0001FFFF, 0, 0, 16 },
	Package() { 0x0001FFFF, 1, 0, 17 },
	Package() { 0x0001FFFF, 2, 0, 18 },
	Package() { 0x0001FFFF, 3, 0, 19 },
	// [CHA2]: Uncore 1 GRP0_CHA0-7 Device
	Package() { 0x000AFFFF, 0, 0, 16 },
	Package() { 0x000AFFFF, 1, 0, 17 },
	Package() { 0x000AFFFF, 2, 0, 18 },
	Package() { 0x000AFFFF, 3, 0, 19 },
	// [CHA3]: Uncore 1 GRP0_CHA8-10 Device
	Package() { 0x00B0FFFF, 0, 0, 16 },
	Package() { 0x00B0FFFF, 1, 0, 17 },
	Package() { 0x00B0FFFF, 2, 0, 18 },
	Package() { 0x00B0FFFF, 3, 0, 19 },
	// [CA00]: Uncore 1 CHAALL0-1 Device
	Package() { 0x001DFFFF, 0, 0, 16 },
	Package() { 0x001DFFFF, 1, 0, 17 },
	Package() { 0x001DFFFF, 2, 0, 18 },
	Package() { 0x001DFFFF, 3, 0, 19 },
	// [PUC0]: Uncore 1 CHASIS_PUINT0-7 Device
	Package() { 0x001EFFFF, 0, 0, 16 },
	Package() { 0x001EFFFF, 1, 0, 17 },
	Package() { 0x001EFFFF, 2, 0, 18 },
	Package() { 0x001EFFFF, 3, 0, 19 },
	// [GN30]: Uncore 1 Gen3Phy Device
	Package() { 0x001FFFFF, 0, 0, 16 },
	Package() { 0x001FFFFF, 1, 0, 17 },
	Package() { 0x001FFFFF, 2, 0, 18 },
	Package() { 0x001FFFFF, 3, 0, 19 },
})

Name (AR12, Package() {
	// [IIO]: MISC Device
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
	// [IIO]: DSA0 Device
	Package() { 0x0001FFFF, 0, 0, 16 },
	Package() { 0x0001FFFF, 1, 0, 17 },
	Package() { 0x0001FFFF, 2, 0, 18 },
	Package() { 0x0001FFFF, 3, 0, 19 },
	// [IIO]: IAX0 Device
	Package() { 0x0002FFFF, 0, 0, 16 },
	Package() { 0x0002FFFF, 1, 0, 17 },
	Package() { 0x0002FFFF, 2, 0, 18 },
	Package() { 0x0002FFFF, 3, 0, 19 },
	// [IIO]: MSM Device
	Package() { 0x0003FFFF, 0, 0, 16 },
	Package() { 0x0003FFFF, 1, 0, 17 },
	Package() { 0x0003FFFF, 2, 0, 18 },
	Package() { 0x0003FFFF, 3, 0, 19 },
	// [IIO]: NPK0 Device
	Package() { 0x0004FFFF, 0, 0, 16 },
	Package() { 0x0004FFFF, 1, 0, 17 },
	Package() { 0x0004FFFF, 2, 0, 18 },
	Package() { 0x0004FFFF, 3, 0, 19 },
})

Name (AR13, Package() {
	//  PCH PCIE express port IRQ routing table, which need align with the definition from AR00
	Package() { 0x0000FFFF, 0, 0, 16 },
	Package() { 0x0000FFFF, 1, 0, 17 },
	Package() { 0x0000FFFF, 2, 0, 18 },
	Package() { 0x0000FFFF, 3, 0, 19 },
})
