---
id: Box shadow
section: utility-classes
---import './box-shadow.css'

## Examples

### Small

```html
<div class="pf-v6-u-box-shadow-sm">Regular</div>
<div class="pf-v6-u-box-shadow-sm-top">Top</div>
<div class="pf-v6-u-box-shadow-sm-right">Right</div>
<div class="pf-v6-u-box-shadow-sm-bottom">Bottom</div>
<div class="pf-v6-u-box-shadow-sm-left">Left</div>

```

### Medium

```html
<div class="pf-v6-u-box-shadow-md">Regular</div>
<div class="pf-v6-u-box-shadow-md-top">Top</div>
<div class="pf-v6-u-box-shadow-md-right">Right</div>
<div class="pf-v6-u-box-shadow-md-bottom">Bottom</div>
<div class="pf-v6-u-box-shadow-md-left">Left</div>

```

### Large

```html
<div class="pf-v6-u-box-shadow-lg">Regular</div>
<div class="pf-v6-u-box-shadow-lg-top">Top</div>
<div class="pf-v6-u-box-shadow-lg-right">Right</div>
<div class="pf-v6-u-box-shadow-lg-bottom">Bottom</div>
<div class="pf-v6-u-box-shadow-lg-left">Left</div>

```

## Documentation

### Overview

Box shadow utility

### Usage

| Class | Applied to | Outcome |
| -- | -- | -- |
| `.pf-v6-u-box-shadow-sm` | `*` |  Applies box-shadow small. |
| `.pf-v6-u-box-shadow-sm-top` | `*` |  Applies box-shadow small top. |
| `.pf-v6-u-box-shadow-sm-right` | `*` |  Applies box-shadow small right. |
| `.pf-v6-u-box-shadow-sm-bottom` | `*` |  Applies box-shadow small bottom. |
| `.pf-v6-u-box-shadow-sm-left` | `*` |  Applies box-shadow small left. |
| `.pf-v6-u-box-shadow-md` | `*` |  Applies box-shadow medium. |
| `.pf-v6-u-box-shadow-md-top` | `*` |  Applies box-shadow medium top. |
| `.pf-v6-u-box-shadow-md-right` | `*` |  Applies box-shadow medium right. |
| `.pf-v6-u-box-shadow-md-bottom` | `*` |  Applies box-shadow medium bottom. |
| `.pf-v6-u-box-shadow-md-left` | `*` |  Applies box-shadow medium left. |
| `.pf-v6-u-box-shadow-lg` | `*` |  Applies box-shadow large. |
| `.pf-v6-u-box-shadow-lg-top` | `*` |  Applies box-shadow large top. |
| `.pf-v6-u-box-shadow-lg-right` | `*` |  Applies box-shadow large right. |
| `.pf-v6-u-box-shadow-lg-bottom` | `*` |  Applies box-shadow large bottom. |
| `.pf-v6-u-box-shadow-lg-left` | `*` |  Applies box-shadow large left. |
