## TFSA-2020-014: Integer truncation in Shard API usage

### CVE Number
CVE-2020-15202

### Impact
The [`Shard`
API](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/util/work_sharder.h#L59-L60)
in TensorFlow expects the last argument to be a function taking two `int64`
(i.e., `long long`) arguments:
```cc
void Shard(int max_parallelism, thread::ThreadPool* workers, int64 total,
           int64 cost_per_unit, std::function<void(int64, int64)> work);
```

However, there are several places in TensorFlow where a lambda taking `int` or
`int32` arguments is [being
used](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/random_op.cc#L204-L205):
```cc
    auto DoWork = [samples_per_alpha, num_alphas, &rng, samples_flat,
                   alpha_flat](int start_output, int limit_output) {...};
    Shard(worker_threads.num_threads, worker_threads.workers,
          num_alphas * samples_per_alpha, kElementCost, DoWork);
```

In these cases, if the amount of work to be parallelized is large enough,
integer truncation occurs. Depending on how the two arguments of the lambda are
used, this can result in segfaults, read/write outside of heap allocated arrays,
stack overflows, or data corruption.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[27b417360cbd671ef55915e4bb6bb06af8b8a832](https://github.com/tensorflow/tensorflow/commit/27b417360cbd671ef55915e4bb6bb06af8b8a832)
and
[ca8c013b5e97b1373b3bb1c97ea655e69f31a575](https://github.com/tensorflow/tensorflow/commit/ca8c013b5e97b1373b3bb1c97ea655e69f31a575).
We will release patch releases for all versions between 1.15 and 2.3.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
