# Repository Guidelines

## Project Structure & Module Organization
- Core Lua modules live in `lua/gitsigns/` (config, handlers, utilities).
- User-facing commands are wired in `plugin/gitsigns.vim`
- Help files under `doc/` get regenerated by `gen_help.lua`.
- Specs plus fixtures sit in `test/`, relying on helpers in `test/gs_helpers.lua`.
- Tooling binaries (Stylua, nvim-test, EmmyLua) are cached in `deps/`.

## Build, Test, and Development Commands
- `make build`: run Stylua over `lua/` + `test/`, then regenerate help files before committing.
- `make test [FILTER=pattern]`: execute the functional suite via nvim-test with the default Neovim runner.
- `make test-010`, `make test-011`, `make test-nightly`: confirm compatibility with multiple Neovim versions.
- `make doc` / `make doc-check`: regenerate help from `lua/gitsigns/config.lua` and fail if docs drift.
- `make format-check` or `make format`: lint or autoformat Lua sources.
- `make emmylua-check`: run optional static analysis after fetching the analyzer.

## Coding Style & Naming Conventions
- Lua code must have emmylua/LuaCATS type annotations
- 2-space indentation, 100-character columns, single quotes for strings.
- Run `make format` and `make emmylua-check` after changing any code

## Testing Guidelines
- Every bug fix must include a spec that reproduces the regression and asserts the desired buffer state, co-located with related modules (for example, `hunk_spec.lua` for hunk logic).
- Keep tests deterministic by guarding optional Git features and running the version matrix (`make test-010 && make test-nightly`) when Neovim internals are touched.

## Commit & Pull Request Guidelines
- History follows a Conventional Commit style: `<type>(<scope>): <verb phrase>` (for instance, `fix(blame): close blame window on bufhidden`), so match that pattern and keep subjects under 72 characters.
- Ensure `make build`, the relevant `make test-*`, and `make doc-check` all pass locally.
