/* SPDX-License-Identifier: GPL-2.0-only */

#include <carrier/gpio.h>

static const struct pad_config gpio_table[] = {
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_0, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_1, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_2, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_3, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_4, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_5, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_6, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_7, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_8, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_9, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_10, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_11, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_12, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_13, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_14, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_BIDIRECT(GPIO_15, 0, DN_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_BIDIRECT(GPIO_16, 1, UP_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_BIDIRECT(GPIO_17, 1, UP_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPI_TRIG_OWN(GPIO_18, UP_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_19, UP_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_20, DN_20K, DEEP, OFF, TxDRxE, DRIVER),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_21, UP_20K, DEEP, OFF, TxDRxE, DRIVER),
	/* GPIO_22 - GPIO (DW0: 0x44800102, DW1: 0x00024100) */
	/* PAD_CFG_GPI_TRIG_IOS_OWN(GPIO_22, NONE, DEEP, OFF, TxDRxE, DISPUPD, DRIVER), */
	/* NEED TO IGNORE: PAD_RX_POL(INVERT) */
	_PAD_CFG_STRUCT(GPIO_22,
		PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE),
		PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(DISPUPD) | PAD_CFG_OWN_GPIO(DRIVER)),
	/* GPIO_23 - GPIO (DW0: 0x44800102, DW1: 0x00024100) */
	/* PAD_CFG_GPI_TRIG_IOS_OWN(GPIO_23, NONE, DEEP, OFF, TxDRxE, DISPUPD, DRIVER), */
	/* NEED TO IGNORE : PAD_RX_POL(INVERT) */
	_PAD_CFG_STRUCT(GPIO_23,
		PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE),
		PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(DISPUPD) | PAD_CFG_OWN_GPIO(DRIVER)),
	/* GPIO_24 - GPIO (DW0: 0x40800102, DW1: 0x00027100) */
	/* PAD_CFG_GPI_TRIG_IOS_OWN(GPIO_24, UP_20K, DEEP, LEVEL, TxDRxE, DISPUPD, ACPI), */
	/* NEED TO IGNORE: PAD_RX_POL(INVERT) */
	_PAD_CFG_STRUCT(GPIO_24,
		PAD_RESET(DEEP) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE),
		PAD_PULL(UP_20K) | PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(DISPUPD)),
	PAD_CFG_GPI_SCI_IOS(GPIO_25, UP_20K, DEEP, LEVEL, INVERT, TxDRxE, DISPUPD),
	PAD_CFG_NF(GPIO_26, NATIVE, DEEP, NF5),
	PAD_CFG_GPI_SCI_IOS(GPIO_27, NONE, DEEP, EDGE_SINGLE, INVERT, TxDRxE, DISPUPD),
	PAD_CFG_GPIO_BIDIRECT(GPIO_28, 0, DN_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_BIDIRECT(GPIO_29, 0, DN_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_30, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_31, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_BIDIRECT(GPIO_32, 1, DN_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_33, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_34, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_35, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_36, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_37, DN_20K, DEEP, HIZCRx0, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_38, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_39, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_40, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_41, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF(GPIO_42, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_43, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_44, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_45, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_46, UP_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_47, UP_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_48, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_49, NATIVE, DEEP, NF1),
	PAD_CFG_GPIO_BIDIRECT(GPIO_62, 1, DN_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_BIDIRECT_IOS(GPIO_63, 0, UP_20K, DEEP, OFF, TxLASTRxE, ENPU, DRIVER),
	PAD_CFG_GPIO_BIDIRECT(GPIO_64, 0, DN_20K, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_BIDIRECT(GPIO_65, 0, NONE, DEEP, OFF, DRIVER),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_66, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_67, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_68, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_69, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_70, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_71, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_72, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_73, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF(TCK, DN_20K, DEEP, NF1),
	PAD_CFG_NF(TRST_B, DN_20K, DEEP, NF1),
	PAD_CFG_NF(TMS, UP_20K, DEEP, NF1),
	PAD_CFG_NF(TDI, UP_20K, DEEP, NF1),
	PAD_CFG_NF(CX_PMODE, NONE, DEEP, NF1),
	PAD_CFG_NF(CX_PREQ_B, UP_20K, DEEP, NF1),
	PAD_CFG_NF(JTAGX, UP_20K, DEEP, NF1),
	PAD_CFG_NF(CX_PRDY_B, UP_20K, DEEP, NF1),
	PAD_CFG_NF(TDO, UP_20K, DEEP, NF1),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(CNV_BRI_DT, DN_20K, DEEP, OFF, IGNORE, DRIVER),
	PAD_CFG_TERM_GPO(CNV_BRI_RSP, 1, UP_20K, DEEP),
	PAD_CFG_TERM_GPO(CNV_RGI_DT, 0, UP_20K, DEEP),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_187, NATIVE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_188, NATIVE, DEEP, NF1),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_189, UP_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_190, UP_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_191, UP_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_192, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_193, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_194, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_195, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_196, NATIVE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_197, NATIVE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_198, NATIVE, DEEP, NF1),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_199, UP_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF(GPIO_200, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_201, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_202, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_203, UP_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_204, UP_20K, DEEP, NF1),
	PAD_CFG_NF(PMC_SPI_FS0, UP_20K, DEEP, NF1),
	PAD_CFG_NF(PMC_SPI_FS1, UP_20K, DEEP, NF1),
	PAD_CFG_NF(PMC_SPI_FS2, UP_20K, DEEP, NF1),
	PAD_CFG_NF(PMC_SPI_RXD, DN_20K, DEEP, NF1),
	PAD_CFG_NF(PMC_SPI_TXD, DN_20K, DEEP, NF1),
	PAD_CFG_NF(PMC_SPI_CLK, DN_20K, DEEP, NF1),
	PAD_CFG_NF(PMIC_PWRGOOD, NONE, DEEP, NF1),
	PAD_CFG_NF(PMIC_RESET_B, NONE, DEEP, NF1),
	PAD_CFG_NF(GPIO_213, NONE, DEEP, NF1),
	PAD_CFG_NF(GPIO_214, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_215, DN_20K, DEEP, NF1),
	PAD_CFG_NF(PMIC_THERMTRIP_B, UP_20K, DEEP, NF1),
	PAD_CFG_NF(PMIC_STDBY, DN_20K, DEEP, NF1),
	PAD_CFG_NF(PROCHOT_B, UP_20K, DEEP, NF1),
	PAD_CFG_NF(PMIC_I2C_SCL, UP_1K, DEEP, NF1),
	PAD_CFG_NF(PMIC_I2C_SDA, UP_1K, DEEP, NF1),
	PAD_CFG_GPIO_HI_Z(GPIO_74, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_75, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_76, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_77, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_78, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_79, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_80, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_81, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_82, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_83, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_NF(GPIO_84, DN_20K, DEEP, NF2),
	PAD_CFG_GPIO_HI_Z(GPIO_85, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_86, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_87, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_88, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_89, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_90, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_91, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_92, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_NF(GPIO_97, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_98, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_99, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_100, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_101, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_102, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_103, NATIVE, DEEP, NF1),
	PAD_CFG_NF(FST_SPI_CLK_FB, NATIVE, DEEP, NF1),
	PAD_CFG_GPIO_HI_Z(GPIO_104, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_105, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_106, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_109, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_110, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_111, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_112, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_113, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_116, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_117, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_118, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_119, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_120, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_121, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_122, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_HI_Z(GPIO_123, DN_20K, DEEP, TxLASTRxE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_124, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_125, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_126, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_127, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_128, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_129, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_130, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_131, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_132, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_133, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_134, UP_20K, DEEP, OFF, IGNORE, DRIVER),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_135, UP_20K, DEEP, OFF, IGNORE, DRIVER),
	PAD_CFG_GPI_SCI_IOS(GPIO_136, UP_20K, DEEP, EDGE_SINGLE, INVERT, TxDRxE, SAME),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_137, UP_20K, DEEP, OFF, IGNORE, DRIVER),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_138, UP_20K, DEEP, OFF, IGNORE, DRIVER),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_139, UP_20K, DEEP, OFF, IGNORE, DRIVER),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_146, DN_20K, DEEP, NF3),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_147, DN_20K, DEEP, NF3),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_148, DN_20K, DEEP, NF3),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_149, DN_20K, DEEP, NF3),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_150, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_151, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_152, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_153, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_154, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_155, DN_20K, DEEP, NF2),
	PAD_CFG_NF(GPIO_209, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_210, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_211, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPIO_212, NATIVE, DEEP, NF1),
	PAD_CFG_GPIO_DRIVER_HI_Z(OSC_CLK_OUT_0, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(OSC_CLK_OUT_1, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(OSC_CLK_OUT_2, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(OSC_CLK_OUT_3, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(OSC_CLK_OUT_4, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_AC_PRESENT, DN_20K, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_BATLOW_B, UP_20K, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_PLTRST_B, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_PWRBTN_B, UP_20K, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_RESETBUTTON_B, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_SLP_S0_B, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_SLP_S3_B, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_SLP_S4_B, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(PMU_SUSCLK, NONE, DEEP, NF1),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(PMU_WAKE_B, 0, DEEP, UP_20K, IGNORE, SAME),
	PAD_CFG_NF_IOSTANDBY_IGNORE(SUS_STAT_B, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(SUSPWRDNACK, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_205, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_206, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_207, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_208, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSSTATE(GPIO_156, DN_20K, DEEP, NF1, Tx0RxDCRx0),
	PAD_CFG_NF_IOSSTATE(GPIO_157, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_158, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_159, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_160, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_161, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_162, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_163, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_164, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_165, UP_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_166, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_167, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_168, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_169, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_170, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_GPIO_DRIVER_HI_Z(GPIO_171, DN_20K, DEEP, IGNORE, SAME),
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_172, DN_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF(GPIO_179, DN_20K, DEEP, NF1),
	PAD_CFG_NF_IOSSTATE(GPIO_173, DN_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_174, DN_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_175, DN_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF_IOSSTATE(GPIO_176, DN_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_GPI_TRIG_IOSSTATE_OWN(GPIO_177, UP_20K, DEEP, EDGE_BOTH, TxDRxE, DRIVER),
	PAD_CFG_NF_IOSSTATE(GPIO_178, DN_20K, DEEP, NF1, HIZCRx1),
	PAD_CFG_NF(GPIO_186, UP_20K, DEEP, NF1),
	PAD_CFG_NF_IOSSTATE(GPIO_182, DN_20K, DEEP, NF1, HIZCRx0),
	PAD_CFG_TERM_GPO(GPIO_183, 1, DN_20K, DEEP),
	PAD_CFG_NF_IOSTANDBY_IGNORE(SMB_ALERTB, NONE, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(SMB_CLK, UP_20K, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(SMB_DATA, UP_20K, DEEP, NF1),
	PAD_CFG_NF_IOSTANDBY_IGNORE(LPC_ILB_SERIRQ, UP_20K, DEEP, NF1),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_CLKOUT0, NONE, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_CLKOUT1, NONE, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD0, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD1, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD2, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD3, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_CLKRUNB, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_FRAMEB, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
};

void carrier_gpio_configure(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
