; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=ppc32-- -ppc-asm-full-reg-names | FileCheck %s

define double @test1(double %a, double %b, double %c, double %d) {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmul f0, f3, f4
; CHECK-NEXT:    fmul f1, f1, f2
; CHECK-NEXT:    fadd f1, f1, f0
; CHECK-NEXT:    blr
  %tmp2 = fsub double -0.000000e+00, %c
  %tmp4 = fmul double %tmp2, %d
  %tmp7 = fmul double %a, %b
  %tmp9 = fsub double %tmp7, %tmp4
  ret double %tmp9
}

declare float @llvm.fmuladd.f32(float, float, float) #4

define float @fma_fneg_fneg(float %x, float %y, float %z) {
; CHECK-LABEL: fma_fneg_fneg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmadds f1, f1, f2, f3
; CHECK-NEXT:    blr
  %negx = fneg float %x
  %negy = fneg float %y
  %r = call float @llvm.fmuladd.f32(float %negx, float %negy, float %z)
  ret float %r
}

define float @fma_fneg_fsub(float %x, float %y0, float %y1, float %z) {
; CHECK-LABEL: fma_fneg_fsub:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fsubs f0, f3, f2
; CHECK-NEXT:    fmadds f1, f1, f0, f4
; CHECK-NEXT:    blr
  %negx = fneg float %x
  %negy = fsub nsz float %y0, %y1
  %r = call float @llvm.fmuladd.f32(float %negx, float %negy, float %z)
  ret float %r
}

; Verify that we didn't hit assertion for this case.
define double @fneg_no_ice(float %x) {
; CHECK-LABEL: fneg_no_ice:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lis r3, .LCPI3_0@ha
; CHECK-NEXT:    lfs f0, .LCPI3_0@l(r3)
; CHECK-NEXT:    fsubs f0, f0, f1
; CHECK-NEXT:    fmul f1, f0, f0
; CHECK-NEXT:    fmul f1, f0, f1
; CHECK-NEXT:    blr
  %y = fsub fast float 1.0, %x
  %e = fpext float %y to double
  %e2 = fmul double %e, %e
  %e3 = fmul double %e, %e2
  ret double %e3
}

define double @fneg_fmul_const(double %x) {
; CHECK-LABEL: fneg_fmul_const:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, .LCPI4_0@ha
; CHECK-NEXT:    lfd f0, .LCPI4_0@l(r3)
; CHECK-NEXT:    fmul f1, f1, f0
; CHECK-NEXT:    blr
entry:
  %f = fmul double %x, 1.2345
  %s = fneg double %f
  ret double %s
}
